#include <iostream>
#include <vector>
#include <algorithm>
#include <stack>

using namespace std;

struct Mast {
    int id;
    long long x;
    long long h;
};

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n;
    if (cin >> n) {
        vector<Mast> masts(n);
        
        for (int i = 0; i < n; ++i) {
            cin >> masts[i].x;
            masts[i].id = i;
        }
        
        for (int i = 0; i < n; ++i) {
            cin >> masts[i].h;
        }

        sort(masts.begin(), masts.end(), [](const Mast& a, const Mast& b) {
            return a.x < b.x;
        });

        vector<int> right_ng(n, -1);
        vector<int> left_ng(n, -1);
        stack<int> s;

        for (int i = n - 1; i >= 0; --i) {
            while (!s.empty() && masts[s.top()].h < masts[i].h) {
                s.pop();
            }
            if (!s.empty()) {
                right_ng[i] = s.top();
            }
            s.push(i);
        }

        while (!s.empty()) s.pop();

        for (int i = 0; i < n; ++i) {
            while (!s.empty() && masts[s.top()].h < masts[i].h) {
                s.pop();
            }
            if (!s.empty()) {
                left_ng[i] = s.top();
            }
            s.push(i);
        }

        vector<long long> results(n, -1);

        for (int i = 0; i < n; ++i) {
            long long min_dist = -1;

            if (right_ng[i] != -1) {
                int r = right_ng[i];
              
                long long dist = (masts[r].x - masts[i].x) - (masts[r].h - masts[i].h);
                if (min_dist == -1 || dist < min_dist) {
                    min_dist = dist;
                }
            }

            if (left_ng[i] != -1) {
                int l = left_ng[i];
      
                long long dist = (masts[i].x - masts[l].x) - (masts[l].h - masts[i].h);
                if (min_dist == -1 || dist < min_dist) {
                    min_dist = dist;
                }
            }

            results[masts[i].id] = min_dist;
        }

        for (int i = 0; i < n; ++i) {
            cout << results[i] << "\n";
        }
    }
    return 0;
}